package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.bd.dashboard.query.Indicator08Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.enums.TbField;
import org.msh.tb.indicators.core.IndicatorTable;
import org.msh.utils.reportgen.highchart.ChartCreator;
import org.msh.utils.reportgen.highchart.ChartOptions;
import org.msh.utils.reportgen.highchart.Series;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Mauricio on 08/05/2017.
 */
@Name("detailedIndicator08")
public class DetailedIndicator08 extends DetailedIndicator<Indicator08Query> {

    @Override
    protected void createIndicators() {

        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

        // set params to indicator query
        getQuery().setIniDate(getIndicatorFilters().getIniDate());
        getQuery().setEndDate(getIndicatorFilters().getEndDate());
        getQuery().setSelectedAdminUnit(auSelected);

        List<Object[]> result = getQuery().getDetailedResult();

        // get root label
        String rootLabel = auSelected == null ? "Bangladesh" : auSelected.getCountryStructure().getName() + ": " + auSelected.getName().getName1();

        populateIndicatorTable(rootLabel);

        for(Object[] r : result){
            String adminUnit = (String) r[0];
            String refBy = (String) r[1];
            Long caseQtt = (Long) r[2];

            if (adminUnit.equals("root")) {
                adminUnit = rootLabel;
            }

            addValue(refBy, adminUnit, caseQtt != null ? caseQtt.floatValue() : 0);
            addValue(getMessage("global.total"), adminUnit, caseQtt != null ? caseQtt.floatValue() : 0);
        }

        // set highlight in root row
        getTable().getRows().get(getTable().getRows().size()-1).setHighlight(true);

        // if user choose to show as percentage, recalculate all numbers as percentage
        if (isShowPerc()) {
            IndicatorTable percentageTable = new IndicatorTable();
            for (IndicatorTable.TableRow row : getTable().getRows()) {
                String totalColumnTitle = getMessage("global.total");
                Float total = null;

                // calculate total
                for (IndicatorTable.TableCell cell : row.getCells()) {
                    if (cell.getColumn().getTitle().equals(totalColumnTitle)) {
                        total = cell.getValue();
                    }
                }

                // create new cells
                for (IndicatorTable.TableCell cell : row.getCells()) {
                    percentageTable.addValue(cell.getColumn().getTitle(), row.getTitle(), calcPercentage(cell.getValue().longValue(), total.longValue()));
                }
            }

            this.setTable(percentageTable);
        }
    }

    private void populateIndicatorTable(String rootLabel) {
        // create administrative unit condition
        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();
        String auCondition = "";

        if (auSelected != null) {
            auCondition = "and au.code like '" + auSelected.getCode() + "%' ";
        }

        List<Object[]> adminUnits = getEntityManager().createQuery("select au.name.name1, fv.name.name1 " +
                "from AdministrativeUnit au, FieldValue fv " +
                "where au.countryStructure.level = :level " + auCondition +
                "and fv.field = :field " +
                "and au.workspace.id = :wsId and fv.workspace.id = :wsId " +
                "order by au.name.name1, fv.displayOrder")
                .setParameter("level", auSelected == null ? 1 : auSelected.getCountryStructure().getLevel() + 1)
                .setParameter("field", TbField.MEDEXAM_REFTOTYPE)
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        for (Object[] o : adminUnits) {
            addValue((String)o[1], (String)o[0], new Float(0));
        }

        // create total column
        for (IndicatorTable.TableRow r : getTable().getRows()) {
            addValue(getMessage("global.total"), r.getTitle(), new Float(0));
        }

        // create root row
        for (IndicatorTable.TableCell cell : getTable().getRows().get(0).getCells()) {
            addValue(cell.getColumn().getTitle(), rootLabel, new Float(0)).getRow().setHighlight(true);
        }
    }

    private Float calcPercentage(Long num1, Long num2) {
        if (num1 == null || num1 <= 0 || num2 == null || num2 <= 0) {
            return new Float(0);
        }

        BigDecimal bd = new BigDecimal((num1*100.0)/num2).setScale(2, RoundingMode.HALF_EVEN);
        Float result = new Float(bd.floatValue());

        return result;
    }

    @Override
    protected Indicator08Query getQueryNewInstance() {
        return new Indicator08Query();
    }

    /**
     * Create data to be generated by the chart
     */
    protected void createChartData() {
        if (getTable() == null)
            return;

        chartCreator = new ChartCreator();
        ChartOptions opt = chartCreator.getOptions();
        opt.getChart().setRenderTo("chartdiv");
        opt.getChart().setType(getIndicatorFilters().getHighChartType());

        // create series
        Map<String, Series> seriesMap = new HashMap<String, Series>();
        for (IndicatorTable.TableColumn c : getTable().getColumns()) {
            if (c.getTitle() != getMessage("global.total")) {
                Series series = opt.addSeries();
                series.setName(c.getTitle());
                seriesMap.put(c.getTitle(), series);
            }
        }

        for (IndicatorTable.TableRow row: getTable().getRows()) {
            opt.getxAxis().getCategories().add(row.getTitle());

            for (IndicatorTable.TableCell cell: row.getCells()) {
                if (cell.getColumn().getTitle() != null && cell.getColumn().getTitle() != getMessage("global.total")) {
                    BigDecimal bd = new BigDecimal(cell.getValue().doubleValue()).setScale(2, RoundingMode.HALF_EVEN);
                    Series series = seriesMap.get(cell.getColumn().getTitle());
                    series.addNewValue(bd.doubleValue());
                }
            }
        }

        opt.getTitle().setText(Messages.instance().get("dashboard.indicator08"));
    }
}
